<div class="l-content-wrap u-cf">
    <div class="l-1-col-master u-cf">
        <main class="l-content-primary">
            <div class='body-content js-body-content'>


                <div class='l-nav-secondary'>

                    <nav class="js-nav-secondary nav-secondary ">
                        <ul class="nav-secondary__l1">
                            <li class="nav-secondary__l1-item">
                                <button type="button" data-toggle="section-nav-menu">Learn &amp; Plan <span
                                        class="button-icon"></span></button>
                                <div id="section-nav-menu" class="nav-secondary__l1-flyout" data-toggler=".is-active">
                                    <ul id="section-nav-drilldown"
                                        class="nav-secondary__l2 vertical menu accordion-menu" data-drilldown
                                        data-auto-height="true" data-animate-height="true" data-parent-link="true">
                                    </ul>
                                </div>
                            </li>
                            <li class="nav-secondary__l1-item"><span>How to Save for Summer Vacation</span></li>
                        </ul>
                    </nav>

                    <script>
                        window.addEventListener('DOMContentLoaded', function () {
                            $(document).ready(function () {
                                $('#section-nav-drilldown').foundation('_showMenu', $('.nav-secondary_active_selector'), true);
                            });
                        });
                    </script>
                </div>

                <div class='bg-white u-pos-relative u-cf'>
                    <div class='content-nav-section' data-short-name='How to Save for Summer Vacation'>
                        <div class="u-pos-relative l-contain">
                            <div class="rtf h1">
                                <h1>How to Start Saving for Summer Vacation</h1>
                            </div>
                            <div class="social js-social">
                            </div>
                        </div>
                    </div>
                    <section class='article-info js-article-info l-contain mt-1' aria-label="Article Information">
                        <div class='article-info-author article-info-author--image'>
                            <img src="<?= base_url('uploads/' . $company_favicon) ?>" height="200" width="200" class="article-author__image"
                                alt="Icon" />
                            <p class='article-author-details'>
                               <span class="article-author__name"><?= implode(' ', array_slice(explode(' ', $company_name), 0, 1)); ?> Financial Tips</span>
                            </p>
                        </div>
                    </section>
                    <div class="content-nav-section" data-short-name="How to Save for Summer Vacation">

                        <div class="rtf mt-4 mb-2 l-contain">
                            <figure class="u-float-l u-cf">
                                <img src="<?= $front_theme ?>/learn-and-plan-images/personal-finance-101/1116302.jpg"
                                    alt="saving for a summer vacation" />
                                <p class='figcaption'></p>
                            </figure>
                            <p>Summer is almost here and that means the vacation you and your family have been dreaming
                                about all winter is just around the corner. Whether it&rsquo;s an in-state trip to
                                historic Gettysburg, a road trip to New York City or Boston, or a couple of weeks
                                abroad, you&rsquo;ve likely put some time into deciding where to go, how to get there,
                                and how much you need to save to make it all happen. But saving for summer vacation
                                isn&rsquo;t easy&mdash;especially when you&rsquo;re already putting money aside for big
                                milestones like <a></a><a href="#../learn-and-plan6065.html">buying a house</a>,
                                <a></a><a href="#../learn-and-plan55b4.html">your child&rsquo;s education</a>, or
                                <a></a><a href="#../learn-and-plan5ce0.html">retirement</a>.</p>
                            <p>Deciding when to start saving for your vacation really comes down to how much
                                you&rsquo;re planning to spend&mdash;but it&rsquo;s always best to start early.
                                Regardless of the size of your budget, there are a number of things you can do to save
                                money for your trip.</p>
                            <h2> 1. Create a Vacation Budget You Can Stick to</h2>
                            <p>To start off, you need to figure out everything you&rsquo;ll be paying for&mdash;and how
                                much you&rsquo;ll be paying. Have you considered transport costs? What about
                                accommodation and food? Are you planning on a guided tour? Do you need camping
                                equipment? And don&rsquo;t forget about those hidden costs like state taxes or currency
                                exchange fees. Once you&rsquo;ve done the math, you&rsquo;ll have a better idea of how
                                much you need to pay upfront (e.g. for flights and reservations) and how much more
                                you&rsquo;ll have to save until you leave. </p>
                            <h2> 2. Set Up Vacation Savings Account</h2>
                            <p>One easy thing you can do to start putting money aside is open a savings account
                                specifically for your summer vacation. Like <a></a><a
                                    href="#../save/holiday-club-and-additional-savings.html">holiday club
                                    accounts</a>&mdash;which people use to save for gift shopping, traveling, and
                                hosting events&mdash;a separate account will protect your vacation fund from being spent
                                elsewhere and let you focus on tracking how close you are to your goal. If your savings
                                plan includes putting a fixed amount towards your fund on every pay day, for instance,
                                then you can set up automatic payments from your <a></a><a
                                    href="#../bank/citadel-checking-accounts.html">checking account.</a> </p>
                            <h2> 3. Cut Back on Expenses</h2>
                            <p>A great summer vacation may mean having to reduce your spending in the months leading up
                                to it. When you&rsquo;re in the planning stages, take some time to review your <a></a><a
                                    href="#../bank/online-and-mobile-banking/citadel-online-and-mobile-banking-tools.html">online
                                    account</a> for your spending habits and identify some key areas where you might cut
                                back. If your family is prone to eating out, consider opting for home cooked
                                meals&mdash;on average they are <a rel="noopener noreferrer"
                                    href="#https://www.moneyunder30.com/the-true-cost-of-eating-in-restaurants-and-how-to-save"
                                    target="_blank">69% cheaper </a>than what you get at a restaurant. Other ways you
                                can save include buying your groceries in bulk, exploring vintage or second-hand stores,
                                and keeping an eye open for sales.
                                While it may be hard to adjust to these practices, keep in mind that all the money you
                                save will go towards your much deserved vacation. </p>
                        </div>
                    </div>
                </div>
                <div class="learn-cta l-bg-gray">
                    <div class="learn-cta-content l-contain">
                        <img src="<?= $front_theme ?>/learn-and-plan-images/cta-bar-icons/save-piggy-bank_92x92b136.svg?h=92&amp;w=92&amp;la=en&amp;hash=FF2ADA50BE2AD620E40FA56A9B887540"
                            class="learn-cta__image" alt="learn and plan" />
                        <p class="learn-cta__text">Ready to start saving for your next vacation? We can help.</p>
                        <a href="save" class="learn-cta__link">Explore Options </a>
                    </div>
                </div>
                <div class="content-nav-section">
                    <div class="rtf mt-4 mb-2 l-contain">
                        <figure><img height="386" alt="person photographing items to sell" width="580"
                                src="<?= $front_theme ?>/learn-and-plan-images/personal-finance-101/header-investing-in-stocks-or-property3fbb.jpg" />
                        </figure>
                        <h2> 4. Sell Unwanted Items</h2>
                        <p>Decluttering can also help you boost your vacation savings. Take advantage of the spring
                            weather and hold a garage sale to make money on the items you don&rsquo;t use anymore. And
                            if you need equipment for your vacation like tents, surfboards, or backpacks, save money by
                            buying them secondhand or by exchanging the things you&rsquo;re getting rid of in your local
                            barter community. </p>
                        <h2> 5. Make Use of Your Tax Refund</h2>
                        <p>Your tax refund can also contribute to a vacation fund. As long as you file by April 15,
                            it&rsquo;s likely your refund will come in before summer starts. Since you&rsquo;ll already
                            have some insight into how big the refund is, you can have it automatically deposited into
                            your account and adjust your savings plan accordingly. For other ideas on how to effectively
                            use your refund and to make sure you&rsquo;re getting the most out of tax return, you can
                            always talk to your<a></a><a href="#../invest/our-investment-team.html"> financial
                                advisor</a>.</p>
                        <h2> 6. Use Credit Card Rewards</h2>
                        <p>Whether you&rsquo;re booking a flight or a hotel, summer vacation is an ideal time to put
                            your credit card rewards to work. Consider changing your current credit card for a <a></a><a
                                href="#../bank/credit-cards/world-mastercard.html">travel rewards program</a> that lines
                            up with your travel style. If you prefer having money in hand, you can also opt for a
                            <a></a><a href="#../bank/credit-cards/cash-rewards-credit-card.html">cashback rewards
                                program</a> that helps you save with every dollar you spend. </p>
                        <p>At <?= implode(' ', array_slice(explode(' ', $company_name), 0, 1)); ?>, we&rsquo;re glad to help our members in all of their saving needs. If
                            you&rsquo;re interested in opening one of our <a></a><a href="#../save.html">savings
                                accounts</a> for your vacation, or want to switch to a <a></a><a
                                href="#../borrow/borrow-credit-cards.html">rewards-based credit card</a>, <a></a><a
                                href="#../member-services/send-us-a-message.html">contact us</a> today.</p>
                    </div>
                </div>
                <div class='l-join-cta content-nav-section' data-short-name='CTA'>
                    <section class="join-cta join-cta--primary" aria-label="Join <?= implode(' ', array_slice(explode(' ', $company_name), 0, 1)); ?>">
                        <div class="join-cta-content l-contain u-align-center">
                            <h2 class="join-cta__title ">Looking for more money saving tips? We have you covered.</h2>
                        </div>
                    </section>
                </div>
                <div class='l-related-links content-nav-section' data-short-name='You Might Also Like'>
                    <section class="related-links l-contain" aria-label="You Might Also Like">
                        <h2 class="h2 related-links__title">You Might Also Like</h2>
                        <a class='related-links__item'
                            href="#get-your-home-ready-for-holiday-guests-without-overspending.html"
                            onclick="dataLayer.push({'event': 'You Might Like_Left'});">
                            <h4 class='related-links__item-category'>Learn &amp; Plan</h4>
                            <h3 class='related-links__item-title'>Get Your Home Ready for Holiday Guests Without
                                Overspending</h3>
                            <p class='related-links__item-caption'>Winter is just around the corner, and it’s time to
                                get your home ready for holiday guests! We have some tricks that will make you and your
                                wallet happy.</p>
                        </a>
                        <a class='related-links__item' href="#how-to-manage-your-finances-after-graduating-college.html"
                            onclick="dataLayer.push({'event': 'You Might Like_Center'});">
                            <h4 class='related-links__item-category'>Learn &amp; Plan</h4>
                            <h3 class='related-links__item-title'>Graduation Finance Tips</h3>
                            <p class='related-links__item-caption'>Learn more about budgeting and saving as a recent
                                college graduate to ensure you’re establishing a secure financial future.</p>
                        </a>
                        <a class='related-links__item' href="#5-common-mistakes-to-avoid-on-tax-return.html"
                            onclick="dataLayer.push({'event': 'You Might Like_Right'});">
                            <h4 class='related-links__item-category'>Learn &amp; Plan</h4>
                            <h3 class='related-links__item-title'>Mistakes to Avoid on Your Tax Return</h3>
                            <p class='related-links__item-caption'>When it comes to filing your tax return, learn about
                                the five common mistakes people make and how they can be avoided.</p>
                        </a>
                    </section>
                </div>


            </div>
        </main>
    </div>
</div>